// API configuration for both local development and production deployment
export const API_CONFIG = {
  // Use relative paths that work with both localhost and subdomain deployments
  BASE_URL: '', // Empty string means relative to current domain
  
  // API endpoints
  ENDPOINTS: {
    SERVICES: '/api/services',
    BLOG_POSTS: '/api/blog-posts',
    TESTIMONIALS: '/api/testimonials',
    YOUTUBE_VIDEOS: '/api/youtube-videos',
    CONTACT: '/api/contact',
    APPOINTMENTS: '/api/appointments',
  }
} as const;

// Helper function to get full API URL
export function getApiUrl(endpoint: string): string {
  // In production, use relative paths
  // In development, also use relative paths since Vite proxy handles it
  return `${API_CONFIG.BASE_URL}${endpoint}`;
}

// Export individual endpoint getters for convenience
export const API_ENDPOINTS = {
  services: () => getApiUrl(API_CONFIG.ENDPOINTS.SERVICES),
  blogPosts: () => getApiUrl(API_CONFIG.ENDPOINTS.BLOG_POSTS),
  testimonials: () => getApiUrl(API_CONFIG.ENDPOINTS.TESTIMONIALS),
  youtubeVideos: () => getApiUrl(API_CONFIG.ENDPOINTS.YOUTUBE_VIDEOS),
  contact: () => getApiUrl(API_CONFIG.ENDPOINTS.CONTACT),
  appointments: () => getApiUrl(API_CONFIG.ENDPOINTS.APPOINTMENTS),
} as const;